package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.model.Tramite;
import com.ejie.ab04b.model.TramiteOS3;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0495s00DaoImpl generated by UDA, 05-Apr-2017 09:34:34.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class TramiteOS3DaoImpl implements TramiteOS3Dao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TRAMITE_095 IDTRAMITE095, t1.TIPO_TRAMITE_095 TIPOTRAMITE095, t1.TERRIT_OS3_095 TERRITOS3095, t1.ANO_OS3_095 ANOOS3095, t1.NUM_OS3_095 NUMOS3095 FROM AB0495S00 t1 ";

	private JdbcTemplate jdbcTemplate;

	/**
	 * Gets the jdbc template.
	 * 
	 *  JdbcTemplate
	 *
	 * @return the jdbc template
	 */
	public JdbcTemplate getJdbcTemplate() {
		return this.jdbcTemplate;
	}

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TramiteOS3> rwMap = new RowMapper<TramiteOS3>() {
		public TramiteOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			TramiteOS3 tram = new TramiteOS3(resultSet.getLong("IDTRAMITE095"),
					new Tramite(resultSet.getLong("TIPOTRAMITE095")), null);

			tram.setOs3(new OS3(resultSet.getString("TERRITOS3095"),
					resultSet.getString("ANOOS3095"),
					resultSet.getInt("NUMOS3095")));

			return tram;
		}
	};

	private RowMapper<TramiteOS3> rwMapPK = new RowMapper<TramiteOS3>() {
		public TramiteOS3 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new TramiteOS3(resultSet.getLong("IDTRAMITE095"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  Ab0495s00
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @return the tramite OS 3
	 */

	public TramiteOS3 add(TramiteOS3 ab0495s00) {
		String query = "INSERT INTO AB0495S00 (ID_TRAMITE_095, TIPO_TRAMITE_095, TERRIT_OS3_095, ANO_OS3_095, NUM_OS3_095, NUM_REGISTRO_095, FEC_REGISTRO_095) VALUES (?,?,?,?,?,?,?)";

		// Obtenemos la secuencia
		ab0495s00.setIdTramite095(
				Secuencias.TRAMITE_OS3.getNextLong(jdbcTemplate));

		this.jdbcTemplate.update(query, ab0495s00.getIdTramite095(),
				ab0495s00.getTipoTramite().getIdTramite089(),
				ab0495s00.getOs3().getTeros3061(),
				ab0495s00.getOs3().getAnoos3061(),
				ab0495s00.getOs3().getNumos3061(),
				ab0495s00.getNumRegistro095(), ab0495s00.getFecRegistro095());
		return ab0495s00;
	}

	/**
	 * Updates a single row in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  Ab0495s00
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @return the tramite OS 3
	 */
	public TramiteOS3 update(TramiteOS3 ab0495s00) {
		String query = "UPDATE AB0495S00 SET TIPO_TRAMITE_095=?, TERRIT_OS3_095=?, ANO_OS3_095=?, NUM_OS3_095=? WHERE ID_TRAMITE_095=?";
		this.jdbcTemplate.update(query, ab0495s00.getTipoTramite(),
				ab0495s00.getOs3().getTeros3061(),
				ab0495s00.getOs3().getAnoos3061(),
				ab0495s00.getOs3().getNumos3061(), ab0495s00.getIdTramite095());
		return ab0495s00;
	}

	/**
	 * Finds a single row in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  Ab0495s00
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @return the tramite OS 3
	 */
	@Transactional(readOnly = true)
	public TramiteOS3 find(TramiteOS3 ab0495s00) {
		StringBuilder query = new StringBuilder(TramiteOS3DaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TRAMITE_095 = ? ");

		List<TramiteOS3> ab0495s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap, ab0495s00.getIdTramite095());
		return (TramiteOS3) DataAccessUtils.uniqueResult(ab0495s00List);
	}

	/**
	 * Removes a single row in the Ab0495s00 table.
	 * 
	 *  ab0495s00            Ab0495s00
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 */
	public void remove(TramiteOS3 ab0495s00) {
		String query = "DELETE FROM AB0495S00 WHERE ID_TRAMITE_095=?";
		this.jdbcTemplate.update(query, ab0495s00.getIdTramite095());
	}

	/**
	 * Finds a list of rows in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0495s00>
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TramiteOS3> findAll(TramiteOS3 ab0495s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(TramiteOS3DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0495s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TramiteOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0495s00 table using like.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0495s00>
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TramiteOS3> findAllLike(TramiteOS3 ab0495s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(TramiteOS3DaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0495s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TramiteOS3>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0495s00 table.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  Long
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(TramiteOS3 ab0495s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0495S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0495s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0495s00 table using like.
	 * 
	 *  ab0495s00
	 *            Ab0495s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(TramiteOS3 ab0495s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0495S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0495s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0495s00 selected for rup_table.
	 * 
	 *  ab0495s00            Ab0495s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0495s00>>
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<TramiteOS3>> reorderSelection(TramiteOS3 ab0495s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(TramiteOS3DaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0495s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, TramiteOS3.class, filterParamList,
				"ID_TRAMITE_095");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TramiteOS3>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0495s00
	 *  searchParams            Ab0495s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0495s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<TramiteOS3>> search(TramiteOS3 filterParams,
			TramiteOS3 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(TramiteOS3DaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, TramiteOS3.class, filterParamList,
				searchSQL, searchParamList, from_alias, "ID_TRAMITE_095");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<TramiteOS3>(this.rwMapPK,
						jqGridRequestDto),
				filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0495s00 entity.
	 * 
	 *  ab0495s00            Ab0495s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TramiteOS3 ab0495s00) {

		StringBuilder where = new StringBuilder(
				TramiteOS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0495s00 != null && ab0495s00.getIdTramite095() != null) {
			where.append(" AND t1.ID_TRAMITE_095 = ?");
			params.add(ab0495s00.getIdTramite095());
		}
		if (ab0495s00 != null && ab0495s00.getTipoTramite() != null) {
			where.append(" AND t1.TIPO_TRAMITE_095 = ?");
			params.add(ab0495s00.getTipoTramite());
		}
		if (ab0495s00 != null && ab0495s00.getOs3() != null
				&& ab0495s00.getOs3().getTeros3061() != null) {
			where.append(" AND t1.TERRIT_OS3_095 = ?");
			params.add(ab0495s00.getOs3().getTeros3061());
		}
		if (ab0495s00 != null && ab0495s00.getOs3() != null
				&& ab0495s00.getOs3().getAnoos3061() != null) {
			where.append(" AND t1.ANO_OS3_095 = ?");
			params.add(ab0495s00.getOs3().getAnoos3061());
		}
		if (ab0495s00 != null && ab0495s00.getOs3() != null
				&& ab0495s00.getOs3().getNumos3061() != null) {
			where.append(" AND t1.NUM_OS3_095 = ?");
			params.add(ab0495s00.getOs3().getNumos3061());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0495s00 entity.
	 * 
	 *  ab0495s00            Ab0495s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0495s00 the ab 0495 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(TramiteOS3 ab0495s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				TramiteOS3DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0495s00 != null && ab0495s00.getIdTramite095() != null) {
			where.append(" AND t1.ID_TRAMITE_095 = ?");
			params.add(ab0495s00.getIdTramite095());
		}
		if (ab0495s00 != null && ab0495s00.getTipoTramite() != null) {
			where.append(" AND t1.TIPO_TRAMITE_095 = ?");
			params.add(ab0495s00.getTipoTramite());
		}
		if (ab0495s00 != null && ab0495s00.getOs3() != null
				&& ab0495s00.getOs3().getTeros3061() != null) {
			where.append(" AND t1.TERRIT_OS3_095 = ?");
			params.add(ab0495s00.getOs3().getTeros3061());
		}
		if (ab0495s00 != null && ab0495s00.getOs3() != null
				&& ab0495s00.getOs3().getAnoos3061() != null) {
			where.append(" AND t1.ANO_OS3_095 = ?");
			params.add(ab0495s00.getOs3().getAnoos3061());
		}
		if (ab0495s00 != null && ab0495s00.getOs3() != null
				&& ab0495s00.getOs3().getNumos3061() != null) {
			where.append(" AND t1.NUM_OS3_095 = ?");
			params.add(ab0495s00.getOs3().getNumos3061());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
